/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_MUTEX_H
#define _UDM_MUTEX_H

/* MUTEX stuff to lock dangerous places in multi-threaded mode */

extern __INDLIB__ int UdmSetLockProc(UDM_ENV * Conf,
		void (*proc)(UDM_AGENT *A,int command,int type,const char *fname,int lineno));

#define UDM_GETLOCK(A,mutex)		if(A->Conf->LockProc)A->Conf->LockProc(A,UDM_LOCK,mutex,__FILE__,__LINE__)
#define UDM_RELEASELOCK(A,mutex)	if(A->Conf->LockProc)A->Conf->LockProc(A,UDM_UNLOCK,mutex,__FILE__,__LINE__)

/* Locking commands */
#define UDM_LOCK		1
#define UDM_UNLOCK		2

/* Locking mutex numbers */
#define UDM_LOCK_CONF		0
#define UDM_LOCK_WIN		1
#define UDM_LOCK_MAX		2

#endif
